import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Initialize the figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Define colors
ingredient1_color = 'red'
ingredient2_color = 'blue'

# Draw dispensers
dispenser1 = patches.Rectangle((1, 8), 2, 1, linewidth=1, edgecolor='black', facecolor=ingredient1_color)
dispenser2 = patches.Rectangle((7, 8), 2, 1, linewidth=1, edgecolor='black', facecolor=ingredient2_color)
ax.add_patch(dispenser1)
ax.add_patch(dispenser2)
ax.text(2, 8.5, 'dispenser1', ha='center', va='center', fontsize=8, color='white')
ax.text(8, 8.5, 'dispenser2', ha='center', va='center', fontsize=8, color='white')

# Draw shots
shot1 = patches.Rectangle((1, 5), 1, 1, linewidth=1, edgecolor='black', facecolor='white')
shot2 = patches.Rectangle((4, 5), 1, 1, linewidth=1, edgecolor='black', facecolor='white')
shot3 = patches.Rectangle((7, 5), 1, 1, linewidth=1, edgecolor='black', facecolor='white')
ax.add_patch(shot1)
ax.add_patch(shot2)
ax.add_patch(shot3)
ax.text(1.5, 5.5, 'shot1\nClean, Empty', ha='center', va='center', fontsize=8)
ax.text(4.5, 5.5, 'shot2\nClean, Empty', ha='center', va='center', fontsize=8)
ax.text(7.5, 5.5, 'shot3\nClean, Empty', ha='center', va='center', fontsize=8)

# Draw shaker
shaker1 = patches.Circle((4.5, 2), 1, linewidth=1, edgecolor='black', facecolor='white')
ax.add_patch(shaker1)
ax.text(4.5, 2, 'shaker1\nClean, Empty\nLevel l0', ha='center', va='center', fontsize=8)

# Draw hands
left_hand = patches.Rectangle((2, 1), 1, 0.5, linewidth=1, edgecolor='black', facecolor='white')
right_hand = patches.Rectangle((7, 1), 1, 0.5, linewidth=1, edgecolor='black', facecolor='white')
ax.add_patch(left_hand)
ax.add_patch(right_hand)
ax.text(2.5, 1.25, 'left\nhand\nEmpty', ha='center', va='center', fontsize=8)
ax.text(7.5, 1.25, 'right\nhand\nEmpty', ha='center', va='center', fontsize=8)

# Set limits and remove axes
ax.set_xlim(0, 10)
ax.set_ylim(0, 10)
ax.axis('off')

# Legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='Ingredient1 (Red)'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='Ingredient2 (Blue)')
]
ax.legend(handles=legend_elements, loc='upper left', fontsize=8)

# Save the figure
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_11.png', bbox_inches='tight')
plt.show()